#include <climits>
#include <algorithm>

#define MAX_M 300000
#define MAX_N 300000

/*
struct Pick
{
    int pos;
    int count;
};

int pickCount = 0;
Pick picks[MAX_M];

void AddPick(int pos)
{
    int i = 0;
    for (; i < pickCount; ++i)
        if (picks[i].pos == pos)
            break;

    if (i == pickCount)
    {
        ++pickCount;
        picks[i].pos = pos;
        picks[i].count = 1;
        return;
    }

    ++picks[i].count;

    if (i == 0)
        return;

    int j = (i - 1) >> 1; 
    if (picks[j].count < picks[i].count)    
        std::swap(picks[j], picks[i]);
    else if ((i & 1) == 0 && picks[i - 1].count < picks[i].count)
        std::swap(picks[i - 1], picks[i]);
 }
 */

/*
int picks[MAX_N + 1];

int Slamke(int N, int* A, int M, int* T, int* X, int* Y)
{
    ++A;
    ++T;
    ++X;
    ++Y;

    int count = 0;

    int minRangeBegin, minRangeEnd;
    int min = INT_MAX;
    int minPos = -1;
    for (int i = 0; i < N; ++i)
        if (A[i] < min)
        {
            min = A[i];
            minPos = i;
        }
    ++minPos;

    int task = 0;
    while (task < M)
    {
        if (T[task] == 1)
        {
            if (minPos >= X[task] && minPos <= Y[task])
            {
                minRangeBegin = X[task];
                minRangeEnd = Y[task];
                break;
            }
        }
        else
            count += (X[task] == minPos);

        ++task;
    }
    ++task;

    //printf("First range: %i, %i\n", minRangeBegin, minRangeEnd);

    while (task < M)
    {                


        while (T[task] == 1 && task < M)
        {
            if (Y[task] >= minRangeBegin && X[task] < minRangeBegin)
                minRangeBegin = X[task];
            if (X[task] <= minRangeEnd && Y[task] > minRangeEnd)
                minRangeEnd = Y[task];
            ++task;
        }

        if (task == M)
            return count;

        //printf("Last range: %i, %i\n", minRangeBegin, minRangeEnd);

        int maxPicks = 0;
        int maxPicksPos = minRangeBegin;

        std::fill(picks + minRangeBegin, picks + minRangeEnd + 1, 0);

        while (T[task] == 2 && task < M)
        {
            if (X[task] >= minRangeBegin && X[task] <= minRangeEnd)
            {
                int p = ++picks[X[task]];
                if (maxPicks < p)
                {
                    maxPicks = p;
                    maxPicksPos = X[task];
                }
            }
            ++task;
        }

        count += maxPicks;
        minPos = maxPicksPos;        
    }

    return count;
}
*/

/*
Test primer 1
6
3 1 4 6 5 2
4
1 2 4
2 5 0
1 4 6
2 5 0
*/

/*
10
9 8 7 6 0 1 2 3 4 5
5
1 2 5
1 4 7
2 3 0
2 6 0
2 3 0
*/

int picks[MAX_N + 1];

int Slamke(int N, int* A, int M, int* T, int* X, int* Y)
{       
    int rangeMax;
    for (int i = M; i > 0; --i)
    {
        if (T[i] == 1)
        {
            rangeMax = *std::max_element(picks + X[i], picks + Y[i] + 1);
            std::fill(picks + X[i], picks + Y[i] + 1, rangeMax);
        }
        else        
            ++picks[X[i]];        

        //printf("picks: |");
        //for (int i = 1; i <= N; ++i)
        //    printf("% 2i|", picks[i]);
        //printf("\n");
    }

    int min = INT_MAX;
    int minPos = 0;
    for (int i = 1; i <= N; ++i)
        if (A[i] < min)
        {
            min = A[i];
            minPos = i;
        }

    return picks[minPos];
}